//
// Copyright (c) 2021 Glauco Pacheco <glauco@cuteserver.io>
// All rights reserved
//

#ifndef CONNECTION_INFO_H
#define CONNECTION_INFO_H

#include "SDK.h"
#include <QString>

namespace Cute
{

class PUBLIC ConnectionInfo
{
public:
    ConnectionInfo() = default;
    ConnectionInfo(bool hasProxy,
                   QString peerIp,
                   quint16 peerPort,
                   QString localIp,
                   quint16 localPort,
                   QString proxyIp,
                   quint16 proxyPort,
                   QString proxiedIp,
                   quint16 proxiedPort);
    ~ConnectionInfo() = default;
    [[nodiscard]] bool hasProxy() const {return m_hasProxy;}
    [[nodiscard]] QString peerIp() const {return m_peerIp;}
    [[nodiscard]] quint16 peerPort() const {return m_peerPort;}
    [[nodiscard]] QString localIp() const {return m_localIp;}
    [[nodiscard]] quint16 localPort() const {return m_localPort;}
    [[nodiscard]] QString proxyIp() const {return m_proxyIp;}
    [[nodiscard]] quint16 proxyPort() const {return m_proxyPort;}
    [[nodiscard]] QString proxiedIp() const {return m_proxiedIp;}
    [[nodiscard]] quint16 proxiedPort() const {return m_proxiedPort;}
    [[nodiscard]] QString locationString() const {return m_locationString;}

private:
    bool m_hasProxy = false;
    QString m_peerIp;
    quint16 m_peerPort = 0;
    QString m_localIp;
    quint16 m_localPort = 0;
    QString m_proxyIp;
    quint16 m_proxyPort = 0;
    QString m_proxiedIp;
    quint16 m_proxiedPort = 0;
    QString m_locationString;
};

}

#endif // CONNECTION_INFO_H
