//
// Copyright (c) 2020 Glauco Pacheco <glauco@cuteserver.io>
// All rights reserved
//

#ifndef CUTE_SERVER_HTTP_RESPONSE_H
#define CUTE_SERVER_HTTP_RESPONSE_H

#include "../SDK.h"
#include "HttpStatusCode.h"
#include <QByteArray>
#include <QMetaType>

namespace Cute::Server
{

class HttpResponsePrivate;

class PUBLIC HttpResponse
{
    friend class HttpParser;
public:
    HttpResponse();
    explicit HttpResponse(HttpStatusCode httpStatusCode, const QByteArray & body = QByteArray(), int majorHttpVersion = 1, int minorHttpVersion = 1);
    explicit HttpResponse(int httpStatusCode, const QByteArray & description = QByteArray(), const QByteArray & body = QByteArray(), int majorHttpVersion = 1, int minorHttpVersion = 1);
    HttpResponse(const HttpResponse & other);
    ~HttpResponse();
    HttpResponse & operator=(const HttpResponse & other);
    bool operator==(const HttpResponse & other) const;
    bool operator!=(const HttpResponse & other) const;
    void clear();
    void write(QByteArray &buffer) const;
    void setHttpVersion(int majorVersion, int minorVersion);
    void setStatusCode(HttpStatusCode statusCode);
    [[nodiscard]] int statusCode() const;
    [[nodiscard]] const QByteArray &description() const;
    void addHeader(const QByteArray &name, const QByteArray &value);
    [[nodiscard]] int headerCount(const QByteArray &name) const;
    [[nodiscard]] QByteArray header(const QByteArray &name) const;
    [[nodiscard]] QVector<QByteArray> headers(const QByteArray &name) const;
    [[nodiscard]] int headersCount() const;
    void setBody(const QByteArray &body);
    [[nodiscard]] const QByteArray &body() const;
    [[nodiscard]] int majorHttpVersion() const;
    [[nodiscard]] int minorHttpVersion() const;

private:
    Q_DECLARE_PRIVATE(HttpResponse)
    HttpResponsePrivate *d_ptr;
};

}

Q_DECLARE_METATYPE(Cute::Server::HttpResponse)

#endif // CUTE_SERVER_HTTP_RESPONSE_H
