//
// Copyright (c) 2020 Glauco Pacheco <glauco@cuteserver.io>
// All rights reserved
//

#ifndef CUTE_SERVER_HTTP_REQUEST_H
#define CUTE_SERVER_HTTP_REQUEST_H

#include "../SDK.h"
#include "HttpRequestMethod.h"
#include <QUrl>
#include <QMetaType>

namespace Cute::Server
{

class HttpRequestPrivate;

class PUBLIC HttpRequest
{
    friend class HttpParser;
public:
    HttpRequest();
    explicit HttpRequest(HttpRequestMethod method, const QUrl &url = QUrl(), const QByteArray &body = QByteArray(), int majorHttpVersion = 1, int minorHttpVersion = 1);
    explicit HttpRequest(const QByteArray &method, const QUrl &url = QUrl(), const QByteArray &body = QByteArray(), int majorHttpVersion = 1, int minorHttpVersion = 1);
    HttpRequest(const HttpRequest &other);
    ~HttpRequest();
    HttpRequest & operator=(const HttpRequest &other);
    bool operator==(const HttpRequest &other) const;
    bool operator!=(const HttpRequest &other) const;
    void clear();
    void setMethod(const QByteArray &method);
    void setMethod(HttpRequestMethod method);
    [[nodiscard]] const QByteArray &method() const;
    void setUrl(const QUrl &url);
    [[nodiscard]] const QUrl &url() const;
    void addHeader(const QByteArray &name, const QByteArray & value);
    [[nodiscard]] int headerCount(const QByteArray &name) const;
    [[nodiscard]] QByteArray header(const QByteArray &name) const;
    [[nodiscard]] QVector<QByteArray> headers(const QByteArray &name) const;
    [[nodiscard]] int headersCount() const;
    void setBody(const QByteArray &body);
    [[nodiscard]] const QByteArray &body() const;
    [[nodiscard]] int majorHttpVersion() const;
    [[nodiscard]] int minorHttpVersion() const;

private:
    Q_DECLARE_PRIVATE(HttpRequest)
    HttpRequestPrivate *d_ptr;
};

}

Q_DECLARE_METATYPE(Cute::Server::HttpRequest)

#endif // CUTE_SERVER_HTTP_REQUEST_H
