//
// Copyright (c) 2020 Glauco Pacheco <glauco@cuteserver.io>
// All rights reserved
//

#ifndef CUTE_SERVER_HTTP_BROKER_H
#define CUTE_SERVER_HTTP_BROKER_H

#include "../SDK.h"
#include "HttpRequest.h"
#include "HttpResponse.h"
#include <QSharedPointer>
#include <QMetaType>


namespace Cute::Server
{

class HttpBrokerPrivate;

class PUBLIC HttpBroker
{;
public:
    HttpBroker();
    ~HttpBroker();
    [[nodiscard]] const HttpRequest &request() const;
    void sendResponse(const HttpResponse &response);

private:
    Q_DECLARE_PRIVATE(HttpBroker)
    HttpBrokerPrivate *d_ptr;
    friend class HttpConnectionHandler;
};

}

Q_DECLARE_METATYPE(QSharedPointer<Cute::Server::HttpBroker>)


#endif // CUTE_SERVER_HTTP_BROKER_H
