//
// Copyright (c) 2021 Glauco Pacheco <glauco@cuteserver.io>
// All rights reserved
//

#ifndef I_CONNECTION_INFORMATION_H
#define I_CONNECTION_INFORMATION_H

#include <QVariant>
#include <QSslConfiguration>
#include <QSslCipher>

namespace Cute
{

class IConnectionInformation
{
public:
    IConnectionInformation() = default;
    virtual ~IConnectionInformation() = default;
    [[nodiscard]] virtual QVariant sessionData() const = 0;
    virtual void dropConnection() = 0;
    [[nodiscard]] virtual bool isProxyProtocolEnabled() const = 0;
    [[nodiscard]] virtual QString localIp() const = 0;
    [[nodiscard]] virtual quint16 localPort() const = 0;
    [[nodiscard]] virtual QString peerIp() const = 0;
    [[nodiscard]] virtual quint16 peerPort() const = 0;
    [[nodiscard]] virtual QString proxyIp() const = 0;
    [[nodiscard]] virtual quint16 proxyPort() const = 0;
    [[nodiscard]] virtual QString proxiedIp() const = 0;
    [[nodiscard]] virtual quint16 proxiedPort() const = 0;
    [[nodiscard]] virtual bool isEncrypted() const = 0;
    [[nodiscard]] virtual QSslConfiguration sslConfiguration() const = 0;
    [[nodiscard]] virtual QSslCipher sessionCipher() const = 0;
    [[nodiscard]] virtual QSsl::SslProtocol sessionProtocol() const = 0;
    [[nodiscard]] virtual QSslCertificate localCertificate() const = 0;
    [[nodiscard]] virtual QList<QSslCertificate> localCertificateChain() const = 0;
    [[nodiscard]] virtual QSslCertificate peerCertificate() const = 0;
    [[nodiscard]] virtual QList<QSslCertificate> peerCertificateChain() const = 0;
};

}

#endif // I_CONNECTION_INFORMATION_H
