//
// Copyright (c) 2020 Glauco Pacheco <glauco@cuteserver.io>
// All rights reserved
//

#ifndef I_REMOTE_OBJECT_CONNECTION_H
#define I_REMOTE_OBJECT_CONNECTION_H

#include "../SDK.h"
#include "../Error.h"
#include <QObject>

namespace Cute::Client
{

class PUBLIC IRemoteObjectConnection : public QObject
{
Q_OBJECT
public:
    IRemoteObjectConnection() = default;
    ~IRemoteObjectConnection() override = default;

signals:
    void connected();
    void disconnected();
    void failed(ErrorInfo error);

private:
    Q_DISABLE_COPY(IRemoteObjectConnection)
};

}

#endif // I_REMOTE_OBJECT_CONNECTION_H
