//
// Copyright (c) 2020 Glauco Pacheco <glauco@cuteserver.io>
// All rights reserved
//

#ifndef I_REMOTE_SLOT_RESPONSE_H
#define I_REMOTE_SLOT_RESPONSE_H

#include "../SDK.h"
#include "../Error.h"
#include <QObject>
#include <QVariant>

namespace Cute::Client
{

class PUBLIC IRemoteSlotResponse : public QObject
{
Q_OBJECT
public:
    IRemoteSlotResponse() = default;
    ~IRemoteSlotResponse() override = default;

signals:
    void responded(QVariant response);
    void failed(Cute::ErrorInfo error);

private:
    Q_DISABLE_COPY(IRemoteSlotResponse)
};

}

#endif // I_REMOTE_SLOT_RESPONSE_H
