//
// Copyright (c) 2020 Glauco Pacheco <glauco@cuteserver.io>
// All rights reserved
//

#ifndef REMOTE_OBJECT_H
#define REMOTE_OBJECT_H

#include "IRemoteSlotResponse.h"
#include "IRemoteObjectConnection.h"
#include "../SDK.h"
#include "../Error.h"
#include "VariadicArguments.h"
#include <QObject>
#include <QUrl>
#include <QVariant>
#include <QSslConfiguration>
#include <QNetworkProxy>
#include <QSharedPointer>
#include <QVector>

namespace Cute::Client
{

class RemoteObjectPrivate;

class PUBLIC RemoteObject : public QObject
{
Q_OBJECT
public:
    RemoteObject(const char *className, const QUrl &remoteObjectUrl, const QVariant &sessionData = QVariant(),
                 const QSslConfiguration &sslConfiguration = QSslConfiguration::defaultConfiguration(),
                 const QNetworkProxy &networkProxy = QNetworkProxy::applicationProxy(),
                 bool exclusiveWebSocketConnection = false);
    ~RemoteObject() override;

    template<typename... RemoteSlotArgs>
    QSharedPointer<IRemoteSlotResponse> callRemoteSlot(const char *remoteSlotName, RemoteSlotArgs... args)
    {
        QVector<QVariant> arguments(10);
        VariadicArguments::checkArgsTypes<RemoteSlotArgs...>();
        VariadicArguments::packArgs(arguments, args...);
        return callRemoteSlotInternal(remoteSlotName, arguments);
    }

    static QSharedPointer<IRemoteObjectConnection> connect(QObject *sender, const char *signal, RemoteObject *receiver, const char *remoteSlot);
    static void disconnect(QObject *sender, const char *signal, RemoteObject *receiver, const char *remoteSlot);
    static QSharedPointer<IRemoteObjectConnection> connect(RemoteObject *sender, const char *remoteSignal, QObject *receiver, const char *slot);
    static void disconnect(RemoteObject *sender, const char *remoteSignal, QObject *receiver, const char *slot);

signals:
    void connected();
    void error(ErrorInfo errorInfo);

private:
    Q_DISABLE_COPY(RemoteObject)
    QSharedPointer<IRemoteSlotResponse> callRemoteSlotInternal(const char *remoteSlotName, const QVector<QVariant> &arguments);

protected:
    RemoteObjectPrivate *d_ptr;
    Q_DECLARE_PRIVATE(RemoteObject)
};

}

#endif // REMOTE_OBJECT_H

